@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Broker AuthorizationConfig properties
 * @property enableCache Enable caching of the authorization rules.
 * @property rules Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
 */
public data class AuthorizationConfigArgs(
    public val enableCache: Output<Boolean>? = null,
    public val rules: Output<List<AuthorizationBasicRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationConfigArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationConfigArgs.builder()
            .enableCache(enableCache?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AuthorizationConfigArgs].
 */
@PulumiTagMarker
public class AuthorizationConfigArgsBuilder internal constructor() {
    private var enableCache: Output<Boolean>? = null

    private var rules: Output<List<AuthorizationBasicRuleArgs>>? = null

    /**
     * @param value Enable caching of the authorization rules.
     */
    @JvmName("fqvfosahrtagsqwt")
    public suspend fun enableCache(`value`: Output<Boolean>) {
        this.enableCache = value
    }

    /**
     * @param value Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("jyknhutsupsrvnyc")
    public suspend fun rules(`value`: Output<List<AuthorizationBasicRuleArgs>>) {
        this.rules = value
    }

    @JvmName("bbvsehgnxvxdajrg")
    public suspend fun rules(vararg values: Output<AuthorizationBasicRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("tnhckntseekeucao")
    public suspend fun rules(values: List<Output<AuthorizationBasicRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Enable caching of the authorization rules.
     */
    @JvmName("owtaauqyfwovybpe")
    public suspend fun enableCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCache = mapped
    }

    /**
     * @param value Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("jkuktvhqhbhfabyk")
    public suspend fun rules(`value`: List<AuthorizationBasicRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("ojefdspfrhqaabaj")
    public suspend fun rules(argument: List<suspend AuthorizationBasicRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AuthorizationBasicRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("amugjeuqivvbtqgr")
    public suspend fun rules(vararg argument: suspend AuthorizationBasicRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AuthorizationBasicRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("siahyuwotcvedusa")
    public suspend fun rules(argument: suspend AuthorizationBasicRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AuthorizationBasicRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
     */
    @JvmName("rpkpajtldjffexlv")
    public suspend fun rules(vararg values: AuthorizationBasicRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AuthorizationConfigArgs = AuthorizationConfigArgs(
        enableCache = enableCache,
        rules = rules,
    )
}
