@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom Authentication properties
 * @property x509 X509 Custom Auth type details.
 */
public data class BrokerAuthenticatorCustomAuthArgs(
    public val x509: Output<BrokerAuthenticatorCustomAuthX509Args>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthArgs.builder()
            .x509(x509.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BrokerAuthenticatorCustomAuthArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorCustomAuthArgsBuilder internal constructor() {
    private var x509: Output<BrokerAuthenticatorCustomAuthX509Args>? = null

    /**
     * @param value X509 Custom Auth type details.
     */
    @JvmName("lujcjhypsoreofjo")
    public suspend fun x509(`value`: Output<BrokerAuthenticatorCustomAuthX509Args>) {
        this.x509 = value
    }

    /**
     * @param value X509 Custom Auth type details.
     */
    @JvmName("wjuemmkiglhmbjie")
    public suspend fun x509(`value`: BrokerAuthenticatorCustomAuthX509Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.x509 = mapped
    }

    /**
     * @param argument X509 Custom Auth type details.
     */
    @JvmName("dpjtpvcjwbkyutkp")
    public suspend fun x509(argument: suspend BrokerAuthenticatorCustomAuthX509ArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorCustomAuthX509ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.x509 = mapped
    }

    internal fun build(): BrokerAuthenticatorCustomAuthArgs = BrokerAuthenticatorCustomAuthArgs(
        x509 = x509 ?: throw PulumiNullFieldException("x509"),
    )
}
