@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Service Account Token for BrokerAuthentication
 * @property audiences List of allowed audience.
 */
public data class BrokerAuthenticatorMethodSatArgs(
    public val audiences: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSatArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSatArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSatArgs.builder()
            .audiences(audiences.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodSatArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodSatArgsBuilder internal constructor() {
    private var audiences: Output<List<String>>? = null

    /**
     * @param value List of allowed audience.
     */
    @JvmName("buhmsgpxpglvyvpp")
    public suspend fun audiences(`value`: Output<List<String>>) {
        this.audiences = value
    }

    @JvmName("feraqtmnfjjrnlpx")
    public suspend fun audiences(vararg values: Output<String>) {
        this.audiences = Output.all(values.asList())
    }

    /**
     * @param values List of allowed audience.
     */
    @JvmName("rsxolgrlfxohkyta")
    public suspend fun audiences(values: List<Output<String>>) {
        this.audiences = Output.all(values)
    }

    /**
     * @param value List of allowed audience.
     */
    @JvmName("ufaneyffcvwufguy")
    public suspend fun audiences(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param values List of allowed audience.
     */
    @JvmName("qkgpreilrktgsatm")
    public suspend fun audiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodSatArgs = BrokerAuthenticatorMethodSatArgs(
        audiences = audiences ?: throw PulumiNullFieldException("audiences"),
    )
}
