@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSvidArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SVID for BrokerAuthentication
 * @property agentSocketPath Mounted socket path for spiffe agent.
 * @property identityMaxRetry Maximum number of re-tries to fetch identity.
 * @property identityWaitRetryMs Maximum time to wait before fetching identity again.
 */
public data class BrokerAuthenticatorMethodSvidArgs(
    public val agentSocketPath: Output<String>,
    public val identityMaxRetry: Output<Double>? = null,
    public val identityWaitRetryMs: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSvidArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSvidArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodSvidArgs.builder()
            .agentSocketPath(agentSocketPath.applyValue({ args0 -> args0 }))
            .identityMaxRetry(identityMaxRetry?.applyValue({ args0 -> args0 }))
            .identityWaitRetryMs(identityWaitRetryMs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodSvidArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodSvidArgsBuilder internal constructor() {
    private var agentSocketPath: Output<String>? = null

    private var identityMaxRetry: Output<Double>? = null

    private var identityWaitRetryMs: Output<Double>? = null

    /**
     * @param value Mounted socket path for spiffe agent.
     */
    @JvmName("foanagraeclphpyd")
    public suspend fun agentSocketPath(`value`: Output<String>) {
        this.agentSocketPath = value
    }

    /**
     * @param value Maximum number of re-tries to fetch identity.
     */
    @JvmName("dccgmntnekwrlimj")
    public suspend fun identityMaxRetry(`value`: Output<Double>) {
        this.identityMaxRetry = value
    }

    /**
     * @param value Maximum time to wait before fetching identity again.
     */
    @JvmName("wxippwhriejmirmh")
    public suspend fun identityWaitRetryMs(`value`: Output<Double>) {
        this.identityWaitRetryMs = value
    }

    /**
     * @param value Mounted socket path for spiffe agent.
     */
    @JvmName("weeibgnjuxnhdskh")
    public suspend fun agentSocketPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentSocketPath = mapped
    }

    /**
     * @param value Maximum number of re-tries to fetch identity.
     */
    @JvmName("cwvbhmidjiwnfspd")
    public suspend fun identityMaxRetry(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityMaxRetry = mapped
    }

    /**
     * @param value Maximum time to wait before fetching identity again.
     */
    @JvmName("rhobqcixbcxucjbp")
    public suspend fun identityWaitRetryMs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityWaitRetryMs = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodSvidArgs = BrokerAuthenticatorMethodSvidArgs(
        agentSocketPath = agentSocketPath ?: throw PulumiNullFieldException("agentSocketPath"),
        identityMaxRetry = identityMaxRetry,
        identityWaitRetryMs = identityWaitRetryMs,
    )
}
