@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509AttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * BrokerAuthenticatorMethodX509Attributes properties. NOTE - Enum only type supported at a time.
 * @property keyVault Keyvault x509 attributes secret properties.
 * @property secretName Secret where x509 attributes are stored.
 */
public data class BrokerAuthenticatorMethodX509AttributesArgs(
    public val keyVault: Output<KeyVaultSecretPropertiesArgs>? = null,
    public val secretName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509AttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509AttributesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509AttributesArgs.builder()
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodX509AttributesArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodX509AttributesArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultSecretPropertiesArgs>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value Keyvault x509 attributes secret properties.
     */
    @JvmName("kevmiekmdsuassnc")
    public suspend fun keyVault(`value`: Output<KeyVaultSecretPropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Secret where x509 attributes are stored.
     */
    @JvmName("uwifsuakhbyjobjb")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Keyvault x509 attributes secret properties.
     */
    @JvmName("wjsrxsuayreveiwt")
    public suspend fun keyVault(`value`: KeyVaultSecretPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Keyvault x509 attributes secret properties.
     */
    @JvmName("dbovdglvykvgssto")
    public suspend fun keyVault(argument: suspend KeyVaultSecretPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Secret where x509 attributes are stored.
     */
    @JvmName("hodrdsxiwyjbjllo")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodX509AttributesArgs =
        BrokerAuthenticatorMethodX509AttributesArgs(
            keyVault = keyVault,
            secretName = secretName,
        )
}
