@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.CardinalityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cardinality properties
 * @property backendChain The backend broker desired properties
 * @property frontend The frontend broker desired properties
 */
public data class CardinalityArgs(
    public val backendChain: Output<BackendChainArgs>,
    public val frontend: Output<FrontendArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.CardinalityArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.CardinalityArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.CardinalityArgs.builder()
            .backendChain(backendChain.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frontend(frontend.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CardinalityArgs].
 */
@PulumiTagMarker
public class CardinalityArgsBuilder internal constructor() {
    private var backendChain: Output<BackendChainArgs>? = null

    private var frontend: Output<FrontendArgs>? = null

    /**
     * @param value The backend broker desired properties
     */
    @JvmName("tevlnuedjfruqtsj")
    public suspend fun backendChain(`value`: Output<BackendChainArgs>) {
        this.backendChain = value
    }

    /**
     * @param value The frontend broker desired properties
     */
    @JvmName("txlpygdhtdfyuwco")
    public suspend fun frontend(`value`: Output<FrontendArgs>) {
        this.frontend = value
    }

    /**
     * @param value The backend broker desired properties
     */
    @JvmName("pfympmrccgkojbtn")
    public suspend fun backendChain(`value`: BackendChainArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendChain = mapped
    }

    /**
     * @param argument The backend broker desired properties
     */
    @JvmName("dgwgmnvkmdawhevq")
    public suspend fun backendChain(argument: suspend BackendChainArgsBuilder.() -> Unit) {
        val toBeMapped = BackendChainArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendChain = mapped
    }

    /**
     * @param value The frontend broker desired properties
     */
    @JvmName("xgjbbbcrjlftnasa")
    public suspend fun frontend(`value`: FrontendArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontend = mapped
    }

    /**
     * @param argument The frontend broker desired properties
     */
    @JvmName("wpffqdcuhqctuoav")
    public suspend fun frontend(argument: suspend FrontendArgsBuilder.() -> Unit) {
        val toBeMapped = FrontendArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontend = mapped
    }

    internal fun build(): CardinalityArgs = CardinalityArgs(
        backendChain = backendChain ?: throw PulumiNullFieldException("backendChain"),
        frontend = frontend ?: throw PulumiNullFieldException("frontend"),
    )
}
