@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerCertOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cert Manager CA Cert properties
 * @property duration Duration of CA cert.
 * @property privateKey Cert Manager private key.
 * @property renewBefore Renew before time of CA cert.
 */
public data class CertManagerCertOptionsArgs(
    public val duration: Output<String>,
    public val privateKey: Output<CertManagerPrivateKeyArgs>,
    public val renewBefore: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerCertOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerCertOptionsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerCertOptionsArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .privateKey(privateKey.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .renewBefore(renewBefore.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertManagerCertOptionsArgs].
 */
@PulumiTagMarker
public class CertManagerCertOptionsArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var privateKey: Output<CertManagerPrivateKeyArgs>? = null

    private var renewBefore: Output<String>? = null

    /**
     * @param value Duration of CA cert.
     */
    @JvmName("siriumvovhsovpwc")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Cert Manager private key.
     */
    @JvmName("uqdeaxvtlktyebqc")
    public suspend fun privateKey(`value`: Output<CertManagerPrivateKeyArgs>) {
        this.privateKey = value
    }

    /**
     * @param value Renew before time of CA cert.
     */
    @JvmName("splejfueotixvoph")
    public suspend fun renewBefore(`value`: Output<String>) {
        this.renewBefore = value
    }

    /**
     * @param value Duration of CA cert.
     */
    @JvmName("aukfpcctsbocqtqc")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Cert Manager private key.
     */
    @JvmName("dorubfscmqvejhoi")
    public suspend fun privateKey(`value`: CertManagerPrivateKeyArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param argument Cert Manager private key.
     */
    @JvmName("xwojpyrwvxdcqaig")
    public suspend fun privateKey(argument: suspend CertManagerPrivateKeyArgsBuilder.() -> Unit) {
        val toBeMapped = CertManagerPrivateKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateKey = mapped
    }

    /**
     * @param value Renew before time of CA cert.
     */
    @JvmName("ejyvhywlaaicyfhr")
    public suspend fun renewBefore(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.renewBefore = mapped
    }

    internal fun build(): CertManagerCertOptionsArgs = CertManagerCertOptionsArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        privateKey = privateKey ?: throw PulumiNullFieldException("privateKey"),
        renewBefore = renewBefore ?: throw PulumiNullFieldException("renewBefore"),
    )
}
