@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Docker image details
 * @property pullPolicy Image pull policy.
 * @property pullSecrets Image pull secrets.
 * @property repository The Docker image name.
 * @property tag The Docker  image tag.
 */
public data class ContainerImageArgs(
    public val pullPolicy: Output<String>? = null,
    public val pullSecrets: Output<String>? = null,
    public val repository: Output<String>,
    public val tag: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs.builder()
            .pullPolicy(pullPolicy?.applyValue({ args0 -> args0 }))
            .pullSecrets(pullSecrets?.applyValue({ args0 -> args0 }))
            .repository(repository.applyValue({ args0 -> args0 }))
            .tag(tag.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerImageArgs].
 */
@PulumiTagMarker
public class ContainerImageArgsBuilder internal constructor() {
    private var pullPolicy: Output<String>? = null

    private var pullSecrets: Output<String>? = null

    private var repository: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value Image pull policy.
     */
    @JvmName("vimpriygqgngamff")
    public suspend fun pullPolicy(`value`: Output<String>) {
        this.pullPolicy = value
    }

    /**
     * @param value Image pull secrets.
     */
    @JvmName("gnbxtcctphhauntn")
    public suspend fun pullSecrets(`value`: Output<String>) {
        this.pullSecrets = value
    }

    /**
     * @param value The Docker image name.
     */
    @JvmName("uoquxrfkylregdas")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value The Docker  image tag.
     */
    @JvmName("rsaefylggltalpme")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value Image pull policy.
     */
    @JvmName("fqigvvjculrrsitk")
    public suspend fun pullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullPolicy = mapped
    }

    /**
     * @param value Image pull secrets.
     */
    @JvmName("ppdoeqiiyjqrnfsc")
    public suspend fun pullSecrets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullSecrets = mapped
    }

    /**
     * @param value The Docker image name.
     */
    @JvmName("gljrptrenpygslab")
    public suspend fun repository(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value The Docker  image tag.
     */
    @JvmName("ktfyansfxhqxtrpa")
    public suspend fun tag(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): ContainerImageArgs = ContainerImageArgs(
        pullPolicy = pullPolicy,
        pullSecrets = pullSecrets,
        repository = repository ?: throw PulumiNullFieldException("repository"),
        tag = tag ?: throw PulumiNullFieldException("tag"),
    )
}
