@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Target storage for the DataLake. NOTE - Enum only storage is supported at a time.
 * @property datalakeStorage DataLake service storage details.
 * @property fabricOneLake Fabric one lake storage details.
 * @property localStorage Local storage details.
 */
public data class DataLakeTargetStorageArgs(
    public val datalakeStorage: Output<DataLakeServiceStorageArgs>? = null,
    public val fabricOneLake: Output<DataLakeFabricStorageArgs>? = null,
    public val localStorage: Output<DataLakeLocalStorageArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs.builder()
            .datalakeStorage(datalakeStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fabricOneLake(fabricOneLake?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localStorage(localStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataLakeTargetStorageArgs].
 */
@PulumiTagMarker
public class DataLakeTargetStorageArgsBuilder internal constructor() {
    private var datalakeStorage: Output<DataLakeServiceStorageArgs>? = null

    private var fabricOneLake: Output<DataLakeFabricStorageArgs>? = null

    private var localStorage: Output<DataLakeLocalStorageArgs>? = null

    /**
     * @param value DataLake service storage details.
     */
    @JvmName("acojwwvkqiutghkf")
    public suspend fun datalakeStorage(`value`: Output<DataLakeServiceStorageArgs>) {
        this.datalakeStorage = value
    }

    /**
     * @param value Fabric one lake storage details.
     */
    @JvmName("deokkbhvfhqptmqi")
    public suspend fun fabricOneLake(`value`: Output<DataLakeFabricStorageArgs>) {
        this.fabricOneLake = value
    }

    /**
     * @param value Local storage details.
     */
    @JvmName("cnolmwkeuuijnynk")
    public suspend fun localStorage(`value`: Output<DataLakeLocalStorageArgs>) {
        this.localStorage = value
    }

    /**
     * @param value DataLake service storage details.
     */
    @JvmName("ljlvnirryyifdkvm")
    public suspend fun datalakeStorage(`value`: DataLakeServiceStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datalakeStorage = mapped
    }

    /**
     * @param argument DataLake service storage details.
     */
    @JvmName("seqjxffpypqjbvgv")
    public suspend fun datalakeStorage(argument: suspend DataLakeServiceStorageArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeServiceStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.datalakeStorage = mapped
    }

    /**
     * @param value Fabric one lake storage details.
     */
    @JvmName("majvkairwgmhsbsi")
    public suspend fun fabricOneLake(`value`: DataLakeFabricStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricOneLake = mapped
    }

    /**
     * @param argument Fabric one lake storage details.
     */
    @JvmName("fbbhadamtxmifwnm")
    public suspend fun fabricOneLake(argument: suspend DataLakeFabricStorageArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeFabricStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fabricOneLake = mapped
    }

    /**
     * @param value Local storage details.
     */
    @JvmName("vagfttusrdjsabrb")
    public suspend fun localStorage(`value`: DataLakeLocalStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorage = mapped
    }

    /**
     * @param argument Local storage details.
     */
    @JvmName("hbmimadgjpiybkio")
    public suspend fun localStorage(argument: suspend DataLakeLocalStorageArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeLocalStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localStorage = mapped
    }

    internal fun build(): DataLakeTargetStorageArgs = DataLakeTargetStorageArgs(
        datalakeStorage = datalakeStorage,
        fabricOneLake = fabricOneLake,
        localStorage = localStorage,
    )
}
