@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableSchemaArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.DeltaTableFormatEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Delta table schema properties
 * @property format Delta table format supported.
 * @property mapping Delta table schema mapping.
 * @property name Delta table schema name.
 * @property optional Delta table schema optional.
 */
public data class DeltaTableSchemaArgs(
    public val format: Output<Either<String, DeltaTableFormatEnum>>,
    public val mapping: Output<String>,
    public val name: Output<String>,
    public val optional: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableSchemaArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableSchemaArgs.builder()
            .format(
                format.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mapping(mapping.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .optional(optional.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeltaTableSchemaArgs].
 */
@PulumiTagMarker
public class DeltaTableSchemaArgsBuilder internal constructor() {
    private var format: Output<Either<String, DeltaTableFormatEnum>>? = null

    private var mapping: Output<String>? = null

    private var name: Output<String>? = null

    private var optional: Output<Boolean>? = null

    /**
     * @param value Delta table format supported.
     */
    @JvmName("tnewigoshfsuskmy")
    public suspend fun format(`value`: Output<Either<String, DeltaTableFormatEnum>>) {
        this.format = value
    }

    /**
     * @param value Delta table schema mapping.
     */
    @JvmName("gfnxqoksjdtdckrt")
    public suspend fun mapping(`value`: Output<String>) {
        this.mapping = value
    }

    /**
     * @param value Delta table schema name.
     */
    @JvmName("gjwdpjnbyxvnceil")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Delta table schema optional.
     */
    @JvmName("qngwqrbqmljrlxfj")
    public suspend fun optional(`value`: Output<Boolean>) {
        this.optional = value
    }

    /**
     * @param value Delta table format supported.
     */
    @JvmName("pgiwavxycrofutte")
    public suspend fun format(`value`: Either<String, DeltaTableFormatEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Delta table format supported.
     */
    @JvmName("haqbrtsrxmtfeude")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeltaTableFormatEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Delta table format supported.
     */
    @JvmName("qifetogasyfwmrkg")
    public fun format(`value`: DeltaTableFormatEnum) {
        val toBeMapped = Either.ofRight<String, DeltaTableFormatEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Delta table schema mapping.
     */
    @JvmName("bivppoetoakarlvh")
    public suspend fun mapping(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapping = mapped
    }

    /**
     * @param value Delta table schema name.
     */
    @JvmName("aqaharoalqqubwtq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Delta table schema optional.
     */
    @JvmName("wvhabldqfjfemlyf")
    public suspend fun optional(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optional = mapped
    }

    internal fun build(): DeltaTableSchemaArgs = DeltaTableSchemaArgs(
        format = format ?: throw PulumiNullFieldException("format"),
        mapping = mapping ?: throw PulumiNullFieldException("mapping"),
        name = name ?: throw PulumiNullFieldException("name"),
        optional = optional ?: throw PulumiNullFieldException("optional"),
    )
}
