@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.ExtendedLocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ExtendedLocation properties
 * @property name The name of the extended location.
 * @property type Type of ExtendedLocation.
 */
public data class ExtendedLocationPropertyArgs(
    public val name: Output<String>,
    public val type: Output<Either<String, ExtendedLocationType>>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs = com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs.builder()
        .name(name.applyValue({ args0 -> args0 }))
        .type(
            type.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [ExtendedLocationPropertyArgs].
 */
@PulumiTagMarker
public class ExtendedLocationPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, ExtendedLocationType>>? = null

    /**
     * @param value The name of the extended location.
     */
    @JvmName("oxoemyublccpukby")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of ExtendedLocation.
     */
    @JvmName("bvfbixxplwbxqiav")
    public suspend fun type(`value`: Output<Either<String, ExtendedLocationType>>) {
        this.type = value
    }

    /**
     * @param value The name of the extended location.
     */
    @JvmName("xlwgkrxjvdgeqoye")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of ExtendedLocation.
     */
    @JvmName("abdkxccceosugjth")
    public suspend fun type(`value`: Either<String, ExtendedLocationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of ExtendedLocation.
     */
    @JvmName("edeqhqfhtvwemluv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of ExtendedLocation.
     */
    @JvmName("qpmwfbuvkrhyhldc")
    public fun type(`value`: ExtendedLocationType) {
        val toBeMapped = Either.ofRight<String, ExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationPropertyArgs = ExtendedLocationPropertyArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
