@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.FrontendArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Desired properties of the Frontend Instances of the DMQTT Broker
 * @property replicas Replicas is desired number of frontend replicas of the given distributed MQTT broker.
 * @property temporaryResourceLimits Defines the limits for resources of the frontend instances of the MQTT broker.
 * @property workers Number of logical frontend workers per pod.
 */
public data class FrontendArgs(
    public val replicas: Output<Int>,
    public val temporaryResourceLimits: Output<TemporaryResourceLimitsConfigArgs>? = null,
    public val workers: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.FrontendArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.FrontendArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.FrontendArgs.builder()
            .replicas(replicas.applyValue({ args0 -> args0 }))
            .temporaryResourceLimits(
                temporaryResourceLimits?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workers(workers?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontendArgs].
 */
@PulumiTagMarker
public class FrontendArgsBuilder internal constructor() {
    private var replicas: Output<Int>? = null

    private var temporaryResourceLimits: Output<TemporaryResourceLimitsConfigArgs>? = null

    private var workers: Output<Int>? = null

    /**
     * @param value Replicas is desired number of frontend replicas of the given distributed MQTT broker.
     */
    @JvmName("cnhokuilhnbnkefy")
    public suspend fun replicas(`value`: Output<Int>) {
        this.replicas = value
    }

    /**
     * @param value Defines the limits for resources of the frontend instances of the MQTT broker.
     */
    @JvmName("kybvihkwufbjwgqk")
    public suspend fun temporaryResourceLimits(`value`: Output<TemporaryResourceLimitsConfigArgs>) {
        this.temporaryResourceLimits = value
    }

    /**
     * @param value Number of logical frontend workers per pod.
     */
    @JvmName("vglgfflkogbmmjfi")
    public suspend fun workers(`value`: Output<Int>) {
        this.workers = value
    }

    /**
     * @param value Replicas is desired number of frontend replicas of the given distributed MQTT broker.
     */
    @JvmName("gteuxjinypmbbxor")
    public suspend fun replicas(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param value Defines the limits for resources of the frontend instances of the MQTT broker.
     */
    @JvmName("wpjcwbtwrveltgqm")
    public suspend fun temporaryResourceLimits(`value`: TemporaryResourceLimitsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryResourceLimits = mapped
    }

    /**
     * @param argument Defines the limits for resources of the frontend instances of the MQTT broker.
     */
    @JvmName("pgcqfgfteptpawtw")
    public suspend fun temporaryResourceLimits(argument: suspend TemporaryResourceLimitsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = TemporaryResourceLimitsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.temporaryResourceLimits = mapped
    }

    /**
     * @param value Number of logical frontend workers per pod.
     */
    @JvmName("onlvmljwbopvaiop")
    public suspend fun workers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workers = mapped
    }

    internal fun build(): FrontendArgs = FrontendArgs(
        replicas = replicas ?: throw PulumiNullFieldException("replicas"),
        temporaryResourceLimits = temporaryResourceLimits,
        workers = workers,
    )
}
