@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorTopicMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kafkaConnectorName Name of MQ kafkaConnector resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topicMapName Name of MQ kafka/topicMap resource
 */
public data class GetKafkaConnectorTopicMapPlainArgs(
    public val kafkaConnectorName: String,
    public val mqName: String,
    public val resourceGroupName: String,
    public val topicMapName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorTopicMapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorTopicMapPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetKafkaConnectorTopicMapPlainArgs.builder()
            .kafkaConnectorName(kafkaConnectorName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicMapName(topicMapName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKafkaConnectorTopicMapPlainArgs].
 */
@PulumiTagMarker
public class GetKafkaConnectorTopicMapPlainArgsBuilder internal constructor() {
    private var kafkaConnectorName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    private var topicMapName: String? = null

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("crgaolbgtsabpgoc")
    public suspend fun kafkaConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kafkaConnectorName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("crxbiffjogprbcpo")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqmcauauqfuhujsn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of MQ kafka/topicMap resource
     */
    @JvmName("rujnhkitifeppxlm")
    public suspend fun topicMapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicMapName = mapped
    }

    internal fun build(): GetKafkaConnectorTopicMapPlainArgs = GetKafkaConnectorTopicMapPlainArgs(
        kafkaConnectorName = kafkaConnectorName ?: throw PulumiNullFieldException("kafkaConnectorName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicMapName = topicMapName ?: throw PulumiNullFieldException("topicMapName"),
    )
}
