@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Local Broker Kubernetes Authentication
 * @property secretPath Secret Path where SAT is mounted.
 * @property serviceAccountTokenName Token name where SAT is mounted on secret path.
 */
public data class LocalBrokerKubernetesAuthenticationArgs(
    public val secretPath: Output<String>? = null,
    public val serviceAccountTokenName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs.builder()
            .secretPath(secretPath?.applyValue({ args0 -> args0 }))
            .serviceAccountTokenName(serviceAccountTokenName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocalBrokerKubernetesAuthenticationArgs].
 */
@PulumiTagMarker
public class LocalBrokerKubernetesAuthenticationArgsBuilder internal constructor() {
    private var secretPath: Output<String>? = null

    private var serviceAccountTokenName: Output<String>? = null

    /**
     * @param value Secret Path where SAT is mounted.
     */
    @JvmName("ukejnwgndyjephju")
    public suspend fun secretPath(`value`: Output<String>) {
        this.secretPath = value
    }

    /**
     * @param value Token name where SAT is mounted on secret path.
     */
    @JvmName("lpowqvyuqtidooan")
    public suspend fun serviceAccountTokenName(`value`: Output<String>) {
        this.serviceAccountTokenName = value
    }

    /**
     * @param value Secret Path where SAT is mounted.
     */
    @JvmName("qymwdtkpvcocoegx")
    public suspend fun secretPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretPath = mapped
    }

    /**
     * @param value Token name where SAT is mounted on secret path.
     */
    @JvmName("uiteiloojfripndr")
    public suspend fun serviceAccountTokenName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountTokenName = mapped
    }

    internal fun build(): LocalBrokerKubernetesAuthenticationArgs =
        LocalBrokerKubernetesAuthenticationArgs(
            secretPath = secretPath,
            serviceAccountTokenName = serviceAccountTokenName,
        )
}
