@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.MqttBridgeRemoteBrokerProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * MqttBridge RemoteBrokerConnectionSpec details
 * @property authentication The remote broker authentication methods. NOTE - Enum only one method is allowed to be passed.
 * @property endpoint The endpoint of remote broker to connect to.
 * @property protocol Protocol for remote connection.
 * @property tls TLS details for Remote broker Connection.
 */
public data class MqttBridgeRemoteBrokerConnectionSpecArgs(
    public val authentication: Output<MqttBridgeRemoteBrokerAuthenticationMethodsArgs>,
    public val endpoint: Output<String>,
    public val protocol: Output<Either<String, MqttBridgeRemoteBrokerProtocol>>? = null,
    public val tls: Output<MqttBridgeRemoteBrokerConnectionTlsArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionSpecArgs.builder()
            .authentication(authentication.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tls(tls.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MqttBridgeRemoteBrokerConnectionSpecArgs].
 */
@PulumiTagMarker
public class MqttBridgeRemoteBrokerConnectionSpecArgsBuilder internal constructor() {
    private var authentication: Output<MqttBridgeRemoteBrokerAuthenticationMethodsArgs>? = null

    private var endpoint: Output<String>? = null

    private var protocol: Output<Either<String, MqttBridgeRemoteBrokerProtocol>>? = null

    private var tls: Output<MqttBridgeRemoteBrokerConnectionTlsArgs>? = null

    /**
     * @param value The remote broker authentication methods. NOTE - Enum only one method is allowed to be passed.
     */
    @JvmName("dhocysrbinxbyehx")
    public suspend fun authentication(`value`: Output<MqttBridgeRemoteBrokerAuthenticationMethodsArgs>) {
        this.authentication = value
    }

    /**
     * @param value The endpoint of remote broker to connect to.
     */
    @JvmName("rglseyqhssbivsmq")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Protocol for remote connection.
     */
    @JvmName("riqbvutiyayibuwh")
    public suspend fun protocol(`value`: Output<Either<String, MqttBridgeRemoteBrokerProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value TLS details for Remote broker Connection.
     */
    @JvmName("btpqtwdubhtswehs")
    public suspend fun tls(`value`: Output<MqttBridgeRemoteBrokerConnectionTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value The remote broker authentication methods. NOTE - Enum only one method is allowed to be passed.
     */
    @JvmName("bkycanojibuhownq")
    public suspend fun authentication(`value`: MqttBridgeRemoteBrokerAuthenticationMethodsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument The remote broker authentication methods. NOTE - Enum only one method is allowed to be passed.
     */
    @JvmName("sexbjwclcplqoire")
    public suspend fun authentication(argument: suspend MqttBridgeRemoteBrokerAuthenticationMethodsArgsBuilder.() -> Unit) {
        val toBeMapped = MqttBridgeRemoteBrokerAuthenticationMethodsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value The endpoint of remote broker to connect to.
     */
    @JvmName("faayvcxadbrbmiym")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Protocol for remote connection.
     */
    @JvmName("kvwxwjhcnokdwclk")
    public suspend fun protocol(`value`: Either<String, MqttBridgeRemoteBrokerProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol for remote connection.
     */
    @JvmName("avrcbtweyvptudkk")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MqttBridgeRemoteBrokerProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol for remote connection.
     */
    @JvmName("qvfkocdaahehcjvg")
    public fun protocol(`value`: MqttBridgeRemoteBrokerProtocol) {
        val toBeMapped = Either.ofRight<String, MqttBridgeRemoteBrokerProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value TLS details for Remote broker Connection.
     */
    @JvmName("tgsbshjhqqxumsbv")
    public suspend fun tls(`value`: MqttBridgeRemoteBrokerConnectionTlsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument TLS details for Remote broker Connection.
     */
    @JvmName("gvmvjeqkbwkcoteg")
    public suspend fun tls(argument: suspend MqttBridgeRemoteBrokerConnectionTlsArgsBuilder.() -> Unit) {
        val toBeMapped = MqttBridgeRemoteBrokerConnectionTlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): MqttBridgeRemoteBrokerConnectionSpecArgs =
        MqttBridgeRemoteBrokerConnectionSpecArgs(
            authentication = authentication ?: throw PulumiNullFieldException("authentication"),
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            protocol = protocol,
            tls = tls ?: throw PulumiNullFieldException("tls"),
        )
}
