@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRouteSharedSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MqttBridgeRoute Shared subscription properties
 * @property groupMinimumShareNumber The group shared subscription minimum share number.
 * @property groupName The group name for Shared subscription.
 */
public data class MqttBridgeRouteSharedSubscriptionArgs(
    public val groupMinimumShareNumber: Output<Int>,
    public val groupName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRouteSharedSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRouteSharedSubscriptionArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRouteSharedSubscriptionArgs.builder()
            .groupMinimumShareNumber(groupMinimumShareNumber.applyValue({ args0 -> args0 }))
            .groupName(groupName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MqttBridgeRouteSharedSubscriptionArgs].
 */
@PulumiTagMarker
public class MqttBridgeRouteSharedSubscriptionArgsBuilder internal constructor() {
    private var groupMinimumShareNumber: Output<Int>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value The group shared subscription minimum share number.
     */
    @JvmName("luklqouqurytkvig")
    public suspend fun groupMinimumShareNumber(`value`: Output<Int>) {
        this.groupMinimumShareNumber = value
    }

    /**
     * @param value The group name for Shared subscription.
     */
    @JvmName("xafgwqdjmwgyyusa")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The group shared subscription minimum share number.
     */
    @JvmName("kjlauhvwpuorykkk")
    public suspend fun groupMinimumShareNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupMinimumShareNumber = mapped
    }

    /**
     * @param value The group name for Shared subscription.
     */
    @JvmName("kifysryucseijwqo")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): MqttBridgeRouteSharedSubscriptionArgs =
        MqttBridgeRouteSharedSubscriptionArgs(
            groupMinimumShareNumber = groupMinimumShareNumber ?: throw
                PulumiNullFieldException("groupMinimumShareNumber"),
            groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        )
}
