@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttToKafkaRoutesArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.KafkaAcks
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Mqtt to Kafka route properties
 * @property kafkaAcks The kafka acks to use.
 * @property kafkaTopic The kafka topic to publish to.
 * @property mqttTopic The mqtt topic to pull from.
 * @property name The name of the route.
 * @property qos The qos to use for mqtt.
 * @property sharedSubscription The properties for shared subscription.
 */
public data class MqttToKafkaRoutesArgs(
    public val kafkaAcks: Output<Either<String, KafkaAcks>>,
    public val kafkaTopic: Output<String>,
    public val mqttTopic: Output<String>,
    public val name: Output<String>,
    public val qos: Output<Int>? = null,
    public val sharedSubscription: Output<KafkaSharedSubscriptionPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttToKafkaRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.MqttToKafkaRoutesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttToKafkaRoutesArgs.builder()
            .kafkaAcks(
                kafkaAcks.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kafkaTopic(kafkaTopic.applyValue({ args0 -> args0 }))
            .mqttTopic(mqttTopic.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .qos(qos?.applyValue({ args0 -> args0 }))
            .sharedSubscription(
                sharedSubscription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MqttToKafkaRoutesArgs].
 */
@PulumiTagMarker
public class MqttToKafkaRoutesArgsBuilder internal constructor() {
    private var kafkaAcks: Output<Either<String, KafkaAcks>>? = null

    private var kafkaTopic: Output<String>? = null

    private var mqttTopic: Output<String>? = null

    private var name: Output<String>? = null

    private var qos: Output<Int>? = null

    private var sharedSubscription: Output<KafkaSharedSubscriptionPropertiesArgs>? = null

    /**
     * @param value The kafka acks to use.
     */
    @JvmName("rimysclnvqyfurwn")
    public suspend fun kafkaAcks(`value`: Output<Either<String, KafkaAcks>>) {
        this.kafkaAcks = value
    }

    /**
     * @param value The kafka topic to publish to.
     */
    @JvmName("xkuacuqlqugftjxa")
    public suspend fun kafkaTopic(`value`: Output<String>) {
        this.kafkaTopic = value
    }

    /**
     * @param value The mqtt topic to pull from.
     */
    @JvmName("uxmvjhxrlbninqey")
    public suspend fun mqttTopic(`value`: Output<String>) {
        this.mqttTopic = value
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("plgbcowrmkqwsjwk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The qos to use for mqtt.
     */
    @JvmName("yuvjywnipseteiux")
    public suspend fun qos(`value`: Output<Int>) {
        this.qos = value
    }

    /**
     * @param value The properties for shared subscription.
     */
    @JvmName("ddhshjpfkicnjnjq")
    public suspend fun sharedSubscription(`value`: Output<KafkaSharedSubscriptionPropertiesArgs>) {
        this.sharedSubscription = value
    }

    /**
     * @param value The kafka acks to use.
     */
    @JvmName("uohpwpatkrhxmxpd")
    public suspend fun kafkaAcks(`value`: Either<String, KafkaAcks>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaAcks = mapped
    }

    /**
     * @param value The kafka acks to use.
     */
    @JvmName("txbqlxgqkvnyndft")
    public fun kafkaAcks(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KafkaAcks>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaAcks = mapped
    }

    /**
     * @param value The kafka acks to use.
     */
    @JvmName("hmbidspxgvokxyiw")
    public fun kafkaAcks(`value`: KafkaAcks) {
        val toBeMapped = Either.ofRight<String, KafkaAcks>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaAcks = mapped
    }

    /**
     * @param value The kafka topic to publish to.
     */
    @JvmName("ufjrxmxvhjjcovpg")
    public suspend fun kafkaTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaTopic = mapped
    }

    /**
     * @param value The mqtt topic to pull from.
     */
    @JvmName("hwrlxgiymnidmdst")
    public suspend fun mqttTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mqttTopic = mapped
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("ocortvumxvdvkded")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The qos to use for mqtt.
     */
    @JvmName("fvxofnerevbpfirm")
    public suspend fun qos(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qos = mapped
    }

    /**
     * @param value The properties for shared subscription.
     */
    @JvmName("kyvdhllswnkqalpj")
    public suspend fun sharedSubscription(`value`: KafkaSharedSubscriptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedSubscription = mapped
    }

    /**
     * @param argument The properties for shared subscription.
     */
    @JvmName("wlfvtyryrmekjrwv")
    public suspend fun sharedSubscription(argument: suspend KafkaSharedSubscriptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaSharedSubscriptionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedSubscription = mapped
    }

    internal fun build(): MqttToKafkaRoutesArgs = MqttToKafkaRoutesArgs(
        kafkaAcks = kafkaAcks ?: throw PulumiNullFieldException("kafkaAcks"),
        kafkaTopic = kafkaTopic ?: throw PulumiNullFieldException("kafkaTopic"),
        mqttTopic = mqttTopic ?: throw PulumiNullFieldException("mqttTopic"),
        name = name ?: throw PulumiNullFieldException("name"),
        qos = qos,
        sharedSubscription = sharedSubscription,
    )
}
