@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.ResourceInfoDefinitionArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.ResourceInfoDefinitionMethods
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ResourceInfoDefinition properties of Basic Rule. This defines the objects that represent the actions or topics, such as - method.Connect, method.Publish, etc.
 * @property method The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
 * @property topics A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
 */
public data class ResourceInfoDefinitionArgs(
    public val method: Output<Either<String, ResourceInfoDefinitionMethods>>,
    public val topics: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.ResourceInfoDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.ResourceInfoDefinitionArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.ResourceInfoDefinitionArgs.builder()
            .method(
                method.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .topics(topics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceInfoDefinitionArgs].
 */
@PulumiTagMarker
public class ResourceInfoDefinitionArgsBuilder internal constructor() {
    private var method: Output<Either<String, ResourceInfoDefinitionMethods>>? = null

    private var topics: Output<List<String>>? = null

    /**
     * @param value The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
     */
    @JvmName("kplbvxjjlyssdagc")
    public suspend fun method(`value`: Output<Either<String, ResourceInfoDefinitionMethods>>) {
        this.method = value
    }

    /**
     * @param value A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
     */
    @JvmName("rpyjhoylwdjelrtr")
    public suspend fun topics(`value`: Output<List<String>>) {
        this.topics = value
    }

    @JvmName("heeecthrfbgonkcd")
    public suspend fun topics(vararg values: Output<String>) {
        this.topics = Output.all(values.asList())
    }

    /**
     * @param values A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
     */
    @JvmName("xkrwdijorvkenbio")
    public suspend fun topics(values: List<Output<String>>) {
        this.topics = Output.all(values)
    }

    /**
     * @param value The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
     */
    @JvmName("qecgxvdmgnebeedn")
    public suspend fun method(`value`: Either<String, ResourceInfoDefinitionMethods>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
     */
    @JvmName("mairdftiarlaxtjw")
    public fun method(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceInfoDefinitionMethods>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
     */
    @JvmName("daimjrvivgtupqvj")
    public fun method(`value`: ResourceInfoDefinitionMethods) {
        val toBeMapped = Either.ofRight<String, ResourceInfoDefinitionMethods>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
     */
    @JvmName("utorbsnnjrtxiqpc")
    public suspend fun topics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param values A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
     */
    @JvmName("odudyiqyljnopjod")
    public suspend fun topics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    internal fun build(): ResourceInfoDefinitionArgs = ResourceInfoDefinitionArgs(
        method = method ?: throw PulumiNullFieldException("method"),
        topics = topics,
    )
}
