@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.TemporaryResourceLimitsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Internal knobs of Resource Limits for FE and BE
 * @property maxInflightMessages Maximum number of messages a client can have inflight.
 * @property maxInflightPatches Maximum number of patch inflight per node.
 * @property maxInflightPatchesPerClient Maximum number of patch a client can have in flight.
 * @property maxMessageExpirySecs Maximum message expiry interval, in seconds.
 * @property maxQueuedMessages Maximum receive for external clients.
 * @property maxQueuedQos0Messages Maximum receive QoS0 for external clients.
 * @property maxSessionExpirySecs Maximum session expiry interval, in seconds.
 */
public data class TemporaryResourceLimitsConfigArgs(
    public val maxInflightMessages: Output<Int>,
    public val maxInflightPatches: Output<Int>,
    public val maxInflightPatchesPerClient: Output<Int>,
    public val maxMessageExpirySecs: Output<Double>? = null,
    public val maxQueuedMessages: Output<Double>,
    public val maxQueuedQos0Messages: Output<Double>,
    public val maxSessionExpirySecs: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.TemporaryResourceLimitsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.TemporaryResourceLimitsConfigArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.TemporaryResourceLimitsConfigArgs.builder()
            .maxInflightMessages(maxInflightMessages.applyValue({ args0 -> args0 }))
            .maxInflightPatches(maxInflightPatches.applyValue({ args0 -> args0 }))
            .maxInflightPatchesPerClient(maxInflightPatchesPerClient.applyValue({ args0 -> args0 }))
            .maxMessageExpirySecs(maxMessageExpirySecs?.applyValue({ args0 -> args0 }))
            .maxQueuedMessages(maxQueuedMessages.applyValue({ args0 -> args0 }))
            .maxQueuedQos0Messages(maxQueuedQos0Messages.applyValue({ args0 -> args0 }))
            .maxSessionExpirySecs(maxSessionExpirySecs.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemporaryResourceLimitsConfigArgs].
 */
@PulumiTagMarker
public class TemporaryResourceLimitsConfigArgsBuilder internal constructor() {
    private var maxInflightMessages: Output<Int>? = null

    private var maxInflightPatches: Output<Int>? = null

    private var maxInflightPatchesPerClient: Output<Int>? = null

    private var maxMessageExpirySecs: Output<Double>? = null

    private var maxQueuedMessages: Output<Double>? = null

    private var maxQueuedQos0Messages: Output<Double>? = null

    private var maxSessionExpirySecs: Output<Double>? = null

    /**
     * @param value Maximum number of messages a client can have inflight.
     */
    @JvmName("ftymjptvmhgpygik")
    public suspend fun maxInflightMessages(`value`: Output<Int>) {
        this.maxInflightMessages = value
    }

    /**
     * @param value Maximum number of patch inflight per node.
     */
    @JvmName("smjrfamyeuvmrdfr")
    public suspend fun maxInflightPatches(`value`: Output<Int>) {
        this.maxInflightPatches = value
    }

    /**
     * @param value Maximum number of patch a client can have in flight.
     */
    @JvmName("daecitmrogbxsket")
    public suspend fun maxInflightPatchesPerClient(`value`: Output<Int>) {
        this.maxInflightPatchesPerClient = value
    }

    /**
     * @param value Maximum message expiry interval, in seconds.
     */
    @JvmName("yygutgjaguthcjdw")
    public suspend fun maxMessageExpirySecs(`value`: Output<Double>) {
        this.maxMessageExpirySecs = value
    }

    /**
     * @param value Maximum receive for external clients.
     */
    @JvmName("femckwsnytymwagi")
    public suspend fun maxQueuedMessages(`value`: Output<Double>) {
        this.maxQueuedMessages = value
    }

    /**
     * @param value Maximum receive QoS0 for external clients.
     */
    @JvmName("hiiddosaumxxptek")
    public suspend fun maxQueuedQos0Messages(`value`: Output<Double>) {
        this.maxQueuedQos0Messages = value
    }

    /**
     * @param value Maximum session expiry interval, in seconds.
     */
    @JvmName("iwsihwmieohvfwah")
    public suspend fun maxSessionExpirySecs(`value`: Output<Double>) {
        this.maxSessionExpirySecs = value
    }

    /**
     * @param value Maximum number of messages a client can have inflight.
     */
    @JvmName("ctshjnxwjjgamedm")
    public suspend fun maxInflightMessages(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxInflightMessages = mapped
    }

    /**
     * @param value Maximum number of patch inflight per node.
     */
    @JvmName("kjchofqjjqmsvmra")
    public suspend fun maxInflightPatches(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxInflightPatches = mapped
    }

    /**
     * @param value Maximum number of patch a client can have in flight.
     */
    @JvmName("ggdyubxpeyixnfps")
    public suspend fun maxInflightPatchesPerClient(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxInflightPatchesPerClient = mapped
    }

    /**
     * @param value Maximum message expiry interval, in seconds.
     */
    @JvmName("clfxxsxdluoaxwsr")
    public suspend fun maxMessageExpirySecs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessageExpirySecs = mapped
    }

    /**
     * @param value Maximum receive for external clients.
     */
    @JvmName("esslxmqdlhgiwldx")
    public suspend fun maxQueuedMessages(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxQueuedMessages = mapped
    }

    /**
     * @param value Maximum receive QoS0 for external clients.
     */
    @JvmName("evdvqvldcrcinwqh")
    public suspend fun maxQueuedQos0Messages(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxQueuedQos0Messages = mapped
    }

    /**
     * @param value Maximum session expiry interval, in seconds.
     */
    @JvmName("lenxbpkkfkiemlvc")
    public suspend fun maxSessionExpirySecs(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxSessionExpirySecs = mapped
    }

    internal fun build(): TemporaryResourceLimitsConfigArgs = TemporaryResourceLimitsConfigArgs(
        maxInflightMessages = maxInflightMessages ?: throw PulumiNullFieldException("maxInflightMessages"),
        maxInflightPatches = maxInflightPatches ?: throw PulumiNullFieldException("maxInflightPatches"),
        maxInflightPatchesPerClient = maxInflightPatchesPerClient ?: throw
            PulumiNullFieldException("maxInflightPatchesPerClient"),
        maxMessageExpirySecs = maxMessageExpirySecs,
        maxQueuedMessages = maxQueuedMessages ?: throw PulumiNullFieldException("maxQueuedMessages"),
        maxQueuedQos0Messages = maxQueuedQos0Messages ?: throw
            PulumiNullFieldException("maxQueuedQos0Messages"),
        maxSessionExpirySecs = maxSessionExpirySecs ?: throw
            PulumiNullFieldException("maxSessionExpirySecs"),
    )
}
