@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VolumeClaimDataSource properties
 * @property apiGroup APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
 * @property kind Kind is the type of resource being referenced
 * @property name Name is the name of resource being referenced
 */
public data class VolumeClaimDataSourceArgs(
    public val apiGroup: Output<String>? = null,
    public val kind: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimDataSourceArgs.builder()
            .apiGroup(apiGroup?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeClaimDataSourceArgs].
 */
@PulumiTagMarker
public class VolumeClaimDataSourceArgsBuilder internal constructor() {
    private var apiGroup: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     */
    @JvmName("qmplcwbkgdtpygiy")
    public suspend fun apiGroup(`value`: Output<String>) {
        this.apiGroup = value
    }

    /**
     * @param value Kind is the type of resource being referenced
     */
    @JvmName("byjcvflmawdkxbuu")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name is the name of resource being referenced
     */
    @JvmName("osicraaeysnakmwf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     */
    @JvmName("qrmagknfilninpfv")
    public suspend fun apiGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiGroup = mapped
    }

    /**
     * @param value Kind is the type of resource being referenced
     */
    @JvmName("hgawgckafdilauqs")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name is the name of resource being referenced
     */
    @JvmName("mmqtuhxbwkdumasg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VolumeClaimDataSourceArgs = VolumeClaimDataSourceArgs(
        apiGroup = apiGroup,
        kind = kind ?: throw PulumiNullFieldException("kind"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
