@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Broker AuthorizationConfig properties
 * @property enableCache Enable caching of the authorization rules.
 * @property rules Authorization Rules to be used. If no rule is set, but Authorization Resource is used that would mean DenyAll.
 */
public data class AuthorizationConfigResponse(
    public val enableCache: Boolean? = null,
    public val rules: List<AuthorizationBasicRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.AuthorizationConfigResponse): AuthorizationConfigResponse = AuthorizationConfigResponse(
            enableCache = javaType.enableCache().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.AuthorizationBasicRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
