@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Desired properties of the Frontend Instances of the DMQTT Broker
 * @property partitions Partitions is desired number of physical backend chains of the given distributed MQTT broker.
 * @property redundancyFactor Redundancy Factor is desired numbers of broker instances in one chain.
 * @property temporaryDiskTransferEnabled Defines whether disk transfer is enabled or not.
 * @property temporaryDiskTransferHighWatermarkPercent Defines the percentage usage of buffer pool above which disk transfer will start.
 * @property temporaryDiskTransferLowWatermarkPercent Defines the percentage usage of buffer pool below which disk transfer will stop.
 * @property temporaryMaxBackendMemUsagePercent Defines the limits for memory usage percent of the backend instances of the MQTT broker.
 * @property temporaryResourceLimits Defines the limits for resources of the backend instances of the MQTT broker.
 * @property workers Number of logical backend workers per pod.
 */
public data class BackendChainResponse(
    public val partitions: Int,
    public val redundancyFactor: Int,
    public val temporaryDiskTransferEnabled: Boolean? = null,
    public val temporaryDiskTransferHighWatermarkPercent: Int? = null,
    public val temporaryDiskTransferLowWatermarkPercent: Int? = null,
    public val temporaryMaxBackendMemUsagePercent: Int? = null,
    public val temporaryResourceLimits: TemporaryResourceLimitsConfigResponse? = null,
    public val workers: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BackendChainResponse): BackendChainResponse = BackendChainResponse(
            partitions = javaType.partitions(),
            redundancyFactor = javaType.redundancyFactor(),
            temporaryDiskTransferEnabled = javaType.temporaryDiskTransferEnabled().map({ args0 ->
                args0
            }).orElse(null),
            temporaryDiskTransferHighWatermarkPercent = javaType.temporaryDiskTransferHighWatermarkPercent().map({ args0 ->
                args0
            }).orElse(null),
            temporaryDiskTransferLowWatermarkPercent = javaType.temporaryDiskTransferLowWatermarkPercent().map({ args0 ->
                args0
            }).orElse(null),
            temporaryMaxBackendMemUsagePercent = javaType.temporaryMaxBackendMemUsagePercent().map({ args0 ->
                args0
            }).orElse(null),
            temporaryResourceLimits = javaType.temporaryResourceLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.TemporaryResourceLimitsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workers = javaType.workers().map({ args0 -> args0 }).orElse(null),
        )
    }
}
