@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * X509 Custom Authentication properties. NOTE - Enum only authenticator type supported at a time.
 * @property keyVault Keyvault X509 secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class BrokerAuthenticatorCustomAuthX509Response(
    public val keyVault: KeyVaultCertificatePropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorCustomAuthX509Response): BrokerAuthenticatorCustomAuthX509Response = BrokerAuthenticatorCustomAuthX509Response(
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
