@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * UsernamePassword for BrokerAuthentication
 * @property keyVault Keyvault username password secret properties.
 * @property secretName Secret where username and password are stored.
 */
public data class BrokerAuthenticatorMethodUsernamePasswordResponse(
    public val keyVault: KeyVaultSecretPropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodUsernamePasswordResponse): BrokerAuthenticatorMethodUsernamePasswordResponse =
            BrokerAuthenticatorMethodUsernamePasswordResponse(
                keyVault = javaType.keyVault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
