@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cert Manager CA Cert properties
 * @property duration Duration of CA cert.
 * @property privateKey Cert Manager private key.
 * @property renewBefore Renew before time of CA cert.
 */
public data class CertManagerCertOptionsResponse(
    public val duration: String,
    public val privateKey: CertManagerPrivateKeyResponse,
    public val renewBefore: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.CertManagerCertOptionsResponse): CertManagerCertOptionsResponse = CertManagerCertOptionsResponse(
            duration = javaType.duration(),
            privateKey = javaType.privateKey().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerPrivateKeyResponse.Companion.toKotlin(args0)
            }),
            renewBefore = javaType.renewBefore(),
        )
    }
}
