@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Cert Manager private key properties
 * @property algorithm algorithm for private key.
 * @property rotationPolicy cert-manager rotationPolicy.
 * @property size size of private key.
 */
public data class CertManagerPrivateKeyResponse(
    public val algorithm: String,
    public val rotationPolicy: String,
    public val size: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.CertManagerPrivateKeyResponse): CertManagerPrivateKeyResponse = CertManagerPrivateKeyResponse(
            algorithm = javaType.algorithm(),
            rotationPolicy = javaType.rotationPolicy(),
            size = javaType.size(),
        )
    }
}
