@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * DataLake connector map route properties
 * @property allowedLatencySecs Allowed latency for transferring data.
 * @property clientId Client Id to use.
 * @property maxMessagesPerBatch Maximum messages to send per Batch.
 * @property messagePayloadType Message payload type.
 * @property mqttSourceTopic Mqtt source topic.
 * @property qos Quality of Service.
 * @property table Delta table properties to use.
 */
public data class DataLakeConnectorMapResponse(
    public val allowedLatencySecs: Int,
    public val clientId: String,
    public val maxMessagesPerBatch: Double,
    public val messagePayloadType: String,
    public val mqttSourceTopic: String,
    public val qos: Int? = null,
    public val table: DeltaTableResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DataLakeConnectorMapResponse): DataLakeConnectorMapResponse = DataLakeConnectorMapResponse(
            allowedLatencySecs = javaType.allowedLatencySecs(),
            clientId = javaType.clientId(),
            maxMessagesPerBatch = javaType.maxMessagesPerBatch(),
            messagePayloadType = javaType.messagePayloadType(),
            mqttSourceTopic = javaType.mqttSourceTopic(),
            qos = javaType.qos().map({ args0 -> args0 }).orElse(null),
            table = javaType.table().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DeltaTableResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
