@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DataLake Fabric Storage details.
 * @property authentication DataLake fabric storage authentication details.
 * @property endpoint DataLake fabric storage endpoint to use.
 * @property fabricPath Fabric path type to use.
 * @property guids Fabric one lake Guids.
 * @property names Fabric one lake Names.
 */
public data class DataLakeFabricStorageResponse(
    public val authentication: DataLakeFabricStorageAuthenticationResponse,
    public val endpoint: String,
    public val fabricPath: String,
    public val guids: FabricGuidsResponse? = null,
    public val names: FabricNamesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DataLakeFabricStorageResponse): DataLakeFabricStorageResponse = DataLakeFabricStorageResponse(
            authentication = javaType.authentication().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeFabricStorageAuthenticationResponse.Companion.toKotlin(args0)
            }),
            endpoint = javaType.endpoint(),
            fabricPath = javaType.fabricPath(),
            guids = javaType.guids().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.FabricGuidsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            names = javaType.names().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.FabricNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
