@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DataLake Service Storage authentication details. NOTE - Enum only one method is supported.
 * @property accessTokenSecretName Access token secret name.
 * @property systemAssignedManagedIdentity Configuration for managed identity authentication.
 */
public data class DataLakeServiceStorageAuthenticationResponse(
    public val accessTokenSecretName: String? = null,
    public val systemAssignedManagedIdentity: ManagedIdentityAuthenticationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DataLakeServiceStorageAuthenticationResponse): DataLakeServiceStorageAuthenticationResponse = DataLakeServiceStorageAuthenticationResponse(
            accessTokenSecretName = javaType.accessTokenSecretName().map({ args0 -> args0 }).orElse(null),
            systemAssignedManagedIdentity = javaType.systemAssignedManagedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ManagedIdentityAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
