@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DataLake Service Storage details.
 * @property authentication DataLake service storage authentication details. NOTE - Enum only one method is supported.
 * @property endpoint DataLake service storage endpoint to use.
 */
public data class DataLakeServiceStorageResponse(
    public val authentication: DataLakeServiceStorageAuthenticationResponse,
    public val endpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DataLakeServiceStorageResponse): DataLakeServiceStorageResponse = DataLakeServiceStorageResponse(
            authentication = javaType.authentication().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeServiceStorageAuthenticationResponse.Companion.toKotlin(args0)
            }),
            endpoint = javaType.endpoint(),
        )
    }
}
