@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Delta table properties
 * @property schema Schema list supported.
 * @property tableName Delta table name.
 * @property tablePath Delta table path.
 */
public data class DeltaTableResponse(
    public val schema: List<DeltaTableSchemaResponse>,
    public val tableName: String,
    public val tablePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DeltaTableResponse): DeltaTableResponse = DeltaTableResponse(
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DeltaTableSchemaResponse.Companion.toKotlin(args0)
                })
            }),
            tableName = javaType.tableName(),
            tablePath = javaType.tablePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
