@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Fabric one lake names.
 * @property lakehouseName Fabric one lake house name.
 * @property workspaceName Fabric one lake workspace name.
 */
public data class FabricNamesResponse(
    public val lakehouseName: String,
    public val workspaceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.FabricNamesResponse): FabricNamesResponse = FabricNamesResponse(
            lakehouseName = javaType.lakehouseName(),
            workspaceName = javaType.workspaceName(),
        )
    }
}
