@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MQ broker resource
 * @property authImage The details of Authentication Docker Image.
 * @property brokerImage The details of Broker Docker Image.
 * @property brokerNodeTolerations The details of Node Tolerations for Broker Pods.
 * @property cardinality The cardinality details of the broker.
 * @property diagnostics The diagnostic details of the broker deployment.
 * @property diskBackedMessageBufferSettings The settings of the disk-backed message buffer.
 * @property encryptInternalTraffic The setting to enable or disable encryption of internal Traffic.
 * @property extendedLocation Extended Location
 * @property healthManagerImage The details of Health Manager Docker Image.
 * @property healthManagerNodeTolerations The details of Node Tolerations for Health Manager Pods.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property internalCerts Details of the internal CA cert that will be used to secure communication between pods.
 * @property location The geo-location where the resource lives
 * @property memoryProfile Memory profile of broker.
 * @property mode The Running Mode of the Broker Deployment.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBrokerResult(
    public val authImage: ContainerImageResponse,
    public val brokerImage: ContainerImageResponse,
    public val brokerNodeTolerations: NodeTolerationsResponse? = null,
    public val cardinality: CardinalityResponse? = null,
    public val diagnostics: BrokerDiagnosticsResponse? = null,
    public val diskBackedMessageBufferSettings: DiskBackedMessageBufferSettingsResponse? = null,
    public val encryptInternalTraffic: Boolean? = null,
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val healthManagerImage: ContainerImageResponse,
    public val healthManagerNodeTolerations: NodeTolerationsResponse? = null,
    public val id: String,
    public val internalCerts: CertManagerCertOptionsResponse? = null,
    public val location: String,
    public val memoryProfile: String? = null,
    public val mode: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetBrokerResult): GetBrokerResult = GetBrokerResult(
            authImage = javaType.authImage().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin(args0)
            }),
            brokerImage = javaType.brokerImage().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin(args0)
            }),
            brokerNodeTolerations = javaType.brokerNodeTolerations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cardinality = javaType.cardinality().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CardinalityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerDiagnosticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskBackedMessageBufferSettings = javaType.diskBackedMessageBufferSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DiskBackedMessageBufferSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptInternalTraffic = javaType.encryptInternalTraffic().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            healthManagerImage = javaType.healthManagerImage().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin(args0)
            }),
            healthManagerNodeTolerations = javaType.healthManagerNodeTolerations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            internalCerts = javaType.internalCerts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerCertOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            memoryProfile = javaType.memoryProfile().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
