@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MQ dataLakeConnector resource
 * @property databaseFormat DataLake database format to use.
 * @property extendedLocation Extended Location
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property image The details of DataLakeConnector Docker Image.
 * @property instances The number of DataLakeConnector pods to spin up.
 * @property localBrokerConnection The details for connecting with Local Broker.
 * @property location The geo-location where the resource lives
 * @property logLevel The log level of the DataLake Connector instances.
 * @property name The name of the resource
 * @property nodeTolerations The Node Tolerations for the DataLake Connector pods.
 * @property protocol The protocol to use for connecting with Brokers.
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property target The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataLakeConnectorResult(
    public val databaseFormat: String,
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val id: String,
    public val image: ContainerImageResponse,
    public val instances: Int? = null,
    public val localBrokerConnection: LocalBrokerConnectionSpecResponse? = null,
    public val location: String,
    public val logLevel: String? = null,
    public val name: String,
    public val nodeTolerations: NodeTolerationsResponse? = null,
    public val protocol: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val target: DataLakeTargetStorageResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetDataLakeConnectorResult): GetDataLakeConnectorResult = GetDataLakeConnectorResult(
            databaseFormat = javaType.databaseFormat(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            image = javaType.image().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin(args0)
            }),
            instances = javaType.instances().map({ args0 -> args0 }).orElse(null),
            localBrokerConnection = javaType.localBrokerConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nodeTolerations = javaType.nodeTolerations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            target = javaType.target().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeTargetStorageResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
