@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MQ diagnostic services resource
 * @property dataExportFrequencySeconds The frequency at which the data will be exported.
 * @property extendedLocation Extended Location
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property image The details of Diagnostic Service Docker Image.
 * @property location The geo-location where the resource lives
 * @property logFormat The format for the logs generated.
 * @property logLevel The format for the logs generated.
 * @property maxDataStorageSize The maximum data stored in MiB.
 * @property metricsPort The port at which metrics is exposed.
 * @property name The name of the resource
 * @property openTelemetryTracesCollectorAddr The destination to collect traces. Diagnostic service will push traces to this endpoint
 * @property provisioningState The status of the last operation.
 * @property staleDataTimeoutSeconds Metric inactivity timeout.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDiagnosticServiceResult(
    public val dataExportFrequencySeconds: Int? = null,
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val id: String,
    public val image: ContainerImageResponse,
    public val location: String,
    public val logFormat: String? = null,
    public val logLevel: String? = null,
    public val maxDataStorageSize: Double? = null,
    public val metricsPort: Int? = null,
    public val name: String,
    public val openTelemetryTracesCollectorAddr: String? = null,
    public val provisioningState: String,
    public val staleDataTimeoutSeconds: Int? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetDiagnosticServiceResult): GetDiagnosticServiceResult = GetDiagnosticServiceResult(
            dataExportFrequencySeconds = javaType.dataExportFrequencySeconds().map({ args0 ->
                args0
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            image = javaType.image().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            logFormat = javaType.logFormat().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            maxDataStorageSize = javaType.maxDataStorageSize().map({ args0 -> args0 }).orElse(null),
            metricsPort = javaType.metricsPort().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            openTelemetryTracesCollectorAddr = javaType.openTelemetryTracesCollectorAddr().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            staleDataTimeoutSeconds = javaType.staleDataTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
