@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * MQ kafkaConnector/topicMap resource
 * @property batching The batching settings for kafka messages.
 * @property compression The compression to use for kafka messages.
 * @property copyMqttProperties The flag to copy Mqtt properties.
 * @property extendedLocation Extended Location
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kafkaConnectorRef The kafkaConnector CRD it refers to.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property partitionKeyProperty The partition to use for Kafka.
 * @property partitionStrategy The partition strategy to use for Kafka.
 * @property provisioningState The status of the last operation.
 * @property routes The route details for Kafka connector.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetKafkaConnectorTopicMapResult(
    public val batching: KafkaTopicMapBatchingResponse? = null,
    public val compression: String? = null,
    public val copyMqttProperties: String? = null,
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val id: String,
    public val kafkaConnectorRef: String,
    public val location: String,
    public val name: String,
    public val partitionKeyProperty: String? = null,
    public val partitionStrategy: String? = null,
    public val provisioningState: String,
    public val routes: List<KafkaRoutesResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetKafkaConnectorTopicMapResult): GetKafkaConnectorTopicMapResult = GetKafkaConnectorTopicMapResult(
            batching = javaType.batching().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaTopicMapBatchingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
            copyMqttProperties = javaType.copyMqttProperties().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            kafkaConnectorRef = javaType.kafkaConnectorRef(),
            location = javaType.location(),
            name = javaType.name(),
            partitionKeyProperty = javaType.partitionKeyProperty().map({ args0 -> args0 }).orElse(null),
            partitionStrategy = javaType.partitionStrategy().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRoutesResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
