@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnectionSpec details
 * @property authentication The remote broker authentication methods.
 * @property endpoint The endpoint of remote broker to connect to.
 * @property tls TLS details for Remote broker Connection.
 */
public data class KafkaRemoteBrokerConnectionSpecResponse(
    public val authentication: KafkaRemoteBrokerAuthenticationPropertiesResponse,
    public val endpoint: String,
    public val tls: KafkaRemoteBrokerConnectionTlsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaRemoteBrokerConnectionSpecResponse): KafkaRemoteBrokerConnectionSpecResponse = KafkaRemoteBrokerConnectionSpecResponse(
            authentication = javaType.authentication().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRemoteBrokerAuthenticationPropertiesResponse.Companion.toKotlin(args0)
            }),
            endpoint = javaType.endpoint(),
            tls = javaType.tls().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRemoteBrokerConnectionTlsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
