@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * KeyVault secret object properties
 * @property name KeyVault secret name.
 * @property version KeyVault secret version.
 */
public data class KeyVaultSecretObjectResponse(
    public val name: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KeyVaultSecretObjectResponse): KeyVaultSecretObjectResponse = KeyVaultSecretObjectResponse(
            name = javaType.name(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
