@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * KeyVault secret properties
 * @property vault KeyVault properties.
 * @property vaultSecret KeyVault secret details.
 */
public data class KeyVaultSecretPropertiesResponse(
    public val vault: KeyVaultConnectionPropertiesResponse,
    public val vaultSecret: KeyVaultSecretObjectResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KeyVaultSecretPropertiesResponse): KeyVaultSecretPropertiesResponse = KeyVaultSecretPropertiesResponse(
            vault = javaType.vault().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            vaultSecret = javaType.vaultSecret().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretObjectResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
