@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Mqtt Local Broker ConnectionSpec details
 * @property authentication The authentication methods for LocalBroker connection. NOTE - Enum only one method at a time is supported.
 * @property endpoint The endpoint of local broker to connect to.
 * @property tls TLS details for Local broker Connection.
 */
public data class LocalBrokerConnectionSpecResponse(
    public val authentication: LocalBrokerAuthenticationMethodsResponse? = null,
    public val endpoint: String? = null,
    public val tls: LocalBrokerConnectionTlsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.LocalBrokerConnectionSpecResponse): LocalBrokerConnectionSpecResponse = LocalBrokerConnectionSpecResponse(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerAuthenticationMethodsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionTlsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
