@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Local Broker Kubernetes Authentication
 * @property secretPath Secret Path where SAT is mounted.
 * @property serviceAccountTokenName Token name where SAT is mounted on secret path.
 */
public data class LocalBrokerKubernetesAuthenticationResponse(
    public val secretPath: String? = null,
    public val serviceAccountTokenName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.LocalBrokerKubernetesAuthenticationResponse): LocalBrokerKubernetesAuthenticationResponse = LocalBrokerKubernetesAuthenticationResponse(
            secretPath = javaType.secretPath().map({ args0 -> args0 }).orElse(null),
            serviceAccountTokenName = javaType.serviceAccountTokenName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
