@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed identity authentication details.
 * @property audience Token audience.
 * @property extensionName Arc Extension name.
 */
public data class ManagedIdentityAuthenticationResponse(
    public val audience: String,
    public val extensionName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.ManagedIdentityAuthenticationResponse): ManagedIdentityAuthenticationResponse = ManagedIdentityAuthenticationResponse(
            audience = javaType.audience(),
            extensionName = javaType.extensionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
