@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Manual TLS server certificate management through a defined secret
 * @property secretName secret containing TLS cert.
 * @property secretNamespace namespace of secret; omit to use default namespace.
 */
public data class ManualCertMethodResponse(
    public val secretName: String,
    public val secretNamespace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.ManualCertMethodResponse): ManualCertMethodResponse = ManualCertMethodResponse(
            secretName = javaType.secretName(),
            secretNamespace = javaType.secretNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
