@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * MqttBridge RemoteBrokerConnection Authentication methods. NOTE - Enum only one is allowed to be passed.
 * @property systemAssignedManagedIdentity Managed identity remote broker authentication method.
 * @property x509 X509 remote broker authentication method.
 */
public data class MqttBridgeRemoteBrokerAuthenticationMethodsResponse(
    public val systemAssignedManagedIdentity: ManagedIdentityAuthenticationResponse? = null,
    public val x509: MqttBridgeRemoteBrokerX509AuthenticationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRemoteBrokerAuthenticationMethodsResponse): MqttBridgeRemoteBrokerAuthenticationMethodsResponse =
            MqttBridgeRemoteBrokerAuthenticationMethodsResponse(
                systemAssignedManagedIdentity = javaType.systemAssignedManagedIdentity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ManagedIdentityAuthenticationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                x509 = javaType.x509().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRemoteBrokerX509AuthenticationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
