@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MqttBridge RemoteBrokerConnectionSpec details
 * @property authentication The remote broker authentication methods. NOTE - Enum only one method is allowed to be passed.
 * @property endpoint The endpoint of remote broker to connect to.
 * @property protocol Protocol for remote connection.
 * @property tls TLS details for Remote broker Connection.
 */
public data class MqttBridgeRemoteBrokerConnectionSpecResponse(
    public val authentication: MqttBridgeRemoteBrokerAuthenticationMethodsResponse,
    public val endpoint: String,
    public val protocol: String? = null,
    public val tls: MqttBridgeRemoteBrokerConnectionTlsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRemoteBrokerConnectionSpecResponse): MqttBridgeRemoteBrokerConnectionSpecResponse = MqttBridgeRemoteBrokerConnectionSpecResponse(
            authentication = javaType.authentication().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRemoteBrokerAuthenticationMethodsResponse.Companion.toKotlin(args0)
            }),
            endpoint = javaType.endpoint(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            tls = javaType.tls().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRemoteBrokerConnectionTlsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
