@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * MqttBridge RemoteBrokerConnection TLS details
 * @property tlsEnabled Tls Enabled on Remote Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate name for Remote Broker.
 */
public data class MqttBridgeRemoteBrokerConnectionTlsResponse(
    public val tlsEnabled: Boolean,
    public val trustedCaCertificateConfigMap: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRemoteBrokerConnectionTlsResponse): MqttBridgeRemoteBrokerConnectionTlsResponse = MqttBridgeRemoteBrokerConnectionTlsResponse(
            tlsEnabled = javaType.tlsEnabled(),
            trustedCaCertificateConfigMap = javaType.trustedCaCertificateConfigMap().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
