@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * MqttBridgeRoute Shared subscription properties
 * @property groupMinimumShareNumber The group shared subscription minimum share number.
 * @property groupName The group name for Shared subscription.
 */
public data class MqttBridgeRouteSharedSubscriptionResponse(
    public val groupMinimumShareNumber: Int,
    public val groupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRouteSharedSubscriptionResponse): MqttBridgeRouteSharedSubscriptionResponse = MqttBridgeRouteSharedSubscriptionResponse(
            groupMinimumShareNumber = javaType.groupMinimumShareNumber(),
            groupName = javaType.groupName(),
        )
    }
}
