@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SANs for certificate.
 * @property dns DNS SANs.
 * @property ip IP address SANs.
 */
public data class SanForCertResponse(
    public val dns: List<String>,
    public val ip: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.SanForCertResponse): SanForCertResponse = SanForCertResponse(
            dns = javaType.dns().map({ args0 -> args0 }),
            ip = javaType.ip().map({ args0 -> args0 }),
        )
    }
}
