@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Internal knobs of Resource Limits for FE and BE
 * @property maxInflightMessages Maximum number of messages a client can have inflight.
 * @property maxInflightPatches Maximum number of patch inflight per node.
 * @property maxInflightPatchesPerClient Maximum number of patch a client can have in flight.
 * @property maxMessageExpirySecs Maximum message expiry interval, in seconds.
 * @property maxQueuedMessages Maximum receive for external clients.
 * @property maxQueuedQos0Messages Maximum receive QoS0 for external clients.
 * @property maxSessionExpirySecs Maximum session expiry interval, in seconds.
 */
public data class TemporaryResourceLimitsConfigResponse(
    public val maxInflightMessages: Int,
    public val maxInflightPatches: Int,
    public val maxInflightPatchesPerClient: Int,
    public val maxMessageExpirySecs: Double? = null,
    public val maxQueuedMessages: Double,
    public val maxQueuedQos0Messages: Double,
    public val maxSessionExpirySecs: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.TemporaryResourceLimitsConfigResponse): TemporaryResourceLimitsConfigResponse = TemporaryResourceLimitsConfigResponse(
            maxInflightMessages = javaType.maxInflightMessages(),
            maxInflightPatches = javaType.maxInflightPatches(),
            maxInflightPatchesPerClient = javaType.maxInflightPatchesPerClient(),
            maxMessageExpirySecs = javaType.maxMessageExpirySecs().map({ args0 -> args0 }).orElse(null),
            maxQueuedMessages = javaType.maxQueuedMessages(),
            maxQueuedQos0Messages = javaType.maxQueuedQos0Messages(),
            maxSessionExpirySecs = javaType.maxSessionExpirySecs(),
        )
    }
}
