@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Collection of different TLS types, NOTE- Enum at a time only one of them needs to be supported
 * @property automatic Option 1 - Automatic TLS server certificate management with cert-manager.
 * @property keyVault Option 3 - TLS server certificate retrieved from Key Vault..
 * @property manual Option 2 - Manual TLS server certificate management through a defined secret.
 */
public data class TlsCertMethodResponse(
    public val automatic: AutomaticCertMethodResponse? = null,
    public val keyVault: KeyVaultCertificatePropertiesResponse? = null,
    public val manual: ManualCertMethodResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.TlsCertMethodResponse): TlsCertMethodResponse = TlsCertMethodResponse(
            automatic = javaType.automatic().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.AutomaticCertMethodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            manual = javaType.manual().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ManualCertMethodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
